const TARGET_URL_PATTERN = /wei\.ltd\.com\/user\/#\/article\/mediatwedit/;
function isTargetPage() {
  return TARGET_URL_PATTERN.test(window.location.href);
}
function showReadyNotification() {
  const notification = document.createElement("div");
  notification.id = "ltd-plugin-notification";
  notification.style.cssText = `
    position: fixed;
    top: 20px;
    right: 20px;
    padding: 16px 24px;
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: white;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 500;
    box-shadow: 0 10px 40px rgba(59, 130, 246, 0.4);
    z-index: 999999;
    display: flex;
    align-items: center;
    gap: 12px;
    animation: slideIn 0.3s ease;
  `;
  notification.innerHTML = `
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
      <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
      <polyline points="22 4 12 14.01 9 11.01"/>
    </svg>
    <span>LTD枢纽云内容发布助手已准备就绪</span>
  `;
  if (!document.getElementById("ltd-plugin-style")) {
    const style = document.createElement("style");
    style.id = "ltd-plugin-style";
    style.textContent = `
      @keyframes slideIn {
        from { transform: translateX(100%); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
      }
    `;
    document.head.appendChild(style);
  }
  document.body.appendChild(notification);
  setTimeout(() => {
    notification.style.animation = "slideIn 0.3s ease reverse";
    setTimeout(() => notification.remove(), 300);
  }, 3e3);
}
function showToast(message, type = "info") {
  const existingToast = document.getElementById("weixin-extractor-toast");
  if (existingToast) existingToast.remove();
  const colors = {
    success: { bg: "#10b981", border: "#059669" },
    error: { bg: "#ef4444", border: "#dc2626" },
    info: { bg: "#6366f1", border: "#4f46e5" }
  };
  const toast = document.createElement("div");
  toast.id = "weixin-extractor-toast";
  toast.style.cssText = `
    position: fixed; top: 20px; right: 20px; padding: 12px 24px;
    background: ${colors[type].bg}; border: 1px solid ${colors[type].border};
    color: white; border-radius: 8px; font-size: 14px; font-weight: 500;
    box-shadow: 0 10px 25px rgba(0,0,0,0.3); z-index: 999999;
  `;
  toast.textContent = message;
  document.body.appendChild(toast);
  setTimeout(() => toast.remove(), 3e3);
}
function findUrlInput() {
  return document.querySelector('input[placeholder="请输入文章URL"]') || document.querySelector('input.el-input__inner[placeholder*="URL"]');
}
function findTitleInput() {
  return document.querySelector('input[placeholder*="标题"]') || document.querySelector('input[placeholder*="请输入文章标题"]');
}
function findRichTextEditor() {
  var _a, _b, _c, _d;
  const tinyMceIframe = document.querySelector("iframe.tox-edit-area__iframe");
  if (tinyMceIframe) {
    const iframeDoc = tinyMceIframe.contentDocument || ((_a = tinyMceIframe.contentWindow) == null ? void 0 : _a.document);
    if (iframeDoc) {
      const body = iframeDoc.body;
      if (body) return body;
    }
  }
  const ckEditor = document.querySelector(".ck-editor__editable");
  if (ckEditor) return ckEditor;
  const quillEditor = document.querySelector(".ql-editor");
  if (quillEditor) return quillEditor;
  const editables = document.querySelectorAll('[contenteditable="true"]');
  let largestEditable = null;
  let maxHeight = 0;
  for (const el of editables) {
    const height = el.offsetHeight;
    if (height > maxHeight) {
      maxHeight = height;
      largestEditable = el;
    }
  }
  if (largestEditable && maxHeight > 100) {
    return largestEditable;
  }
  const wangEditor = document.querySelector(".w-e-text");
  if (wangEditor) return wangEditor;
  const ueditorBody = document.querySelector('iframe[id^="ueditor"]');
  if (ueditorBody) {
    const iframeDoc = ueditorBody.contentDocument || ((_b = ueditorBody.contentWindow) == null ? void 0 : _b.document);
    if (iframeDoc == null ? void 0 : iframeDoc.body) return iframeDoc.body;
  }
  const iframes = document.querySelectorAll("iframe");
  for (const iframe of iframes) {
    try {
      const iframeDoc = iframe.contentDocument || ((_c = iframe.contentWindow) == null ? void 0 : _c.document);
      if (((_d = iframeDoc == null ? void 0 : iframeDoc.body) == null ? void 0 : _d.contentEditable) === "true" || (iframeDoc == null ? void 0 : iframeDoc.designMode) === "on") {
        return iframeDoc.body;
      }
    } catch {
    }
  }
  return null;
}
function setInputValue(element, value) {
  var _a;
  const nativeSetter = (_a = Object.getOwnPropertyDescriptor(HTMLInputElement.prototype, "value")) == null ? void 0 : _a.set;
  if (nativeSetter) {
    nativeSetter.call(element, value);
  } else {
    element.value = value;
  }
  element.dispatchEvent(new Event("input", { bubbles: true }));
  element.dispatchEvent(new Event("change", { bubbles: true }));
}
function setRichTextContent(editor, htmlContent) {
  console.log("设置富文本内容，长度:", htmlContent.length);
  editor.innerHTML = htmlContent;
  editor.dispatchEvent(new Event("input", { bubbles: true }));
  editor.dispatchEvent(new Event("change", { bubbles: true }));
  editor.focus();
  setTimeout(() => editor.blur(), 100);
}
async function collectArticle() {
  var _a;
  console.log("=== 开始采集 ===");
  const urlInput = findUrlInput();
  if (!urlInput) {
    showToast("未找到文章 URL 输入框", "error");
    return;
  }
  const url = urlInput.value.trim();
  if (!url) {
    showToast("请先输入文章 URL", "error");
    return;
  }
  if (!url.includes("mp.weixin.qq.com")) {
    showToast("请输入有效的微信公众号文章链接", "error");
    return;
  }
  showToast("正在采集文章内容...", "info");
  try {
    const response = await chrome.runtime.sendMessage({
      action: "FETCH_WEIXIN_ARTICLE",
      data: { url }
    });
    console.log("API 响应:", response);
    if (!(response == null ? void 0 : response.success) || !response.data) {
      throw new Error((response == null ? void 0 : response.error) || "获取文章失败");
    }
    const article = response.data;
    console.log("文章标题:", article.title);
    console.log("文章内容长度:", (_a = article.content) == null ? void 0 : _a.length);
    const titleInput = findTitleInput();
    if (titleInput && article.title) {
      setInputValue(titleInput, article.title);
      console.log("✓ 已填充标题");
    } else {
      console.log("✗ 未找到标题输入框或标题为空");
    }
    const richEditor = findRichTextEditor();
    console.log("富文本编辑器:", richEditor);
    if (richEditor && article.content) {
      setRichTextContent(richEditor, article.content);
      console.log("✓ 已填充内容到富文本编辑器");
    } else {
      console.log("✗ 未找到富文本编辑器或内容为空");
      console.log("页面上的 contenteditable 元素:");
      document.querySelectorAll('[contenteditable="true"]').forEach((el, i) => {
        console.log(`  ${i}:`, el);
      });
      console.log("页面上的 iframe:");
      document.querySelectorAll("iframe").forEach((el, i) => {
        console.log(`  ${i}:`, el);
      });
    }
    showToast("文章内容采集成功！", "success");
  } catch (error) {
    console.error("采集失败:", error);
    showToast(error instanceof Error ? error.message : "采集失败", "error");
  }
}
function findCollectButton() {
  var _a;
  const btn = document.querySelector("a.HowTo_Seo");
  if (btn) return btn;
  const spans = document.querySelectorAll("span.el-link--inner");
  for (const span of spans) {
    if (((_a = span.textContent) == null ? void 0 : _a.trim()) === "采集") {
      return span.closest("a");
    }
  }
  return null;
}
function interceptCollectButton() {
  var _a;
  const btn = findCollectButton();
  if (!btn) {
    console.log("未找到采集按钮");
    return false;
  }
  if (btn.hasAttribute("data-intercepted")) {
    return true;
  }
  console.log("找到采集按钮:", btn);
  btn.setAttribute("data-intercepted", "true");
  const newBtn = btn.cloneNode(true);
  newBtn.setAttribute("data-intercepted", "true");
  newBtn.addEventListener("click", (e) => {
    e.preventDefault();
    e.stopPropagation();
    e.stopImmediatePropagation();
    console.log(">>> 采集按钮被点击（插件拦截）");
    collectArticle();
    return false;
  }, true);
  (_a = btn.parentNode) == null ? void 0 : _a.replaceChild(newBtn, btn);
  console.log("✓ 采集按钮已被拦截替换");
  return true;
}
function watchAndIntercept() {
  let attempts = 0;
  const maxAttempts = 30;
  const tryIntercept = () => {
    if (interceptCollectButton()) {
      console.log("=== 拦截设置成功 ===");
      return;
    }
    attempts++;
    if (attempts < maxAttempts) {
      setTimeout(tryIntercept, 500);
    }
  };
  setTimeout(tryIntercept, 1e3);
  const observer = new MutationObserver(() => {
    const btn = findCollectButton();
    if (btn && !btn.hasAttribute("data-intercepted")) {
      interceptCollectButton();
    }
  });
  observer.observe(document.body, { childList: true, subtree: true });
}
function watchUrlChange() {
  let lastUrl = window.location.href;
  const check = () => {
    if (window.location.href !== lastUrl) {
      lastUrl = window.location.href;
      if (isTargetPage()) {
        setTimeout(() => watchAndIntercept(), 1e3);
      }
    }
  };
  setInterval(check, 300);
  window.addEventListener("hashchange", check);
}
chrome.runtime.onMessage.addListener((message, _sender, sendResponse) => {
  if (message.action === "PING") {
    sendResponse({ success: true });
    return true;
  }
  return false;
});
function init() {
  console.log("╔════════════════════════════════════════╗");
  console.log("║   LTD枢纽云内容发布助手 v1.1           ║");
  console.log("╠════════════════════════════════════════╣");
  console.log("║ 目标页面:", isTargetPage() ? "是 ✓" : "否 ✗");
  console.log("╚════════════════════════════════════════╝");
  if (isTargetPage()) {
    setTimeout(() => showReadyNotification(), 500);
    if (document.readyState === "complete") {
      watchAndIntercept();
    } else {
      window.addEventListener("load", () => watchAndIntercept());
    }
  }
  watchUrlChange();
}
init();
