chrome.runtime.onMessage.addListener(
  (message, _sender, sendResponse) => {
    var _a;
    if (message.action === "FETCH_WEIXIN_ARTICLE") {
      fetchWeixinArticle(((_a = message.data) == null ? void 0 : _a.url) || "").then((article) => {
        sendResponse({ success: true, data: article });
      }).catch((error) => {
        sendResponse({ success: false, error: error.message });
      });
      return true;
    }
    if (message.action === "PING") {
      sendResponse({ success: true });
      return true;
    }
    return false;
  }
);
async function fetchWeixinArticle(url) {
  if (!url) {
    throw new Error("URL 不能为空");
  }
  if (!url.includes("mp.weixin.qq.com")) {
    throw new Error("请输入有效的微信公众号文章链接");
  }
  try {
    const response = await fetch(url, {
      headers: {
        "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36",
        "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8",
        "Accept-Language": "zh-CN,zh;q=0.9,en;q=0.8"
      }
    });
    if (!response.ok) {
      throw new Error(`HTTP 错误: ${response.status}`);
    }
    const html = await response.text();
    return parseWeixinArticle(html);
  } catch (error) {
    if (error instanceof Error) {
      throw new Error(`获取文章失败: ${error.message}`);
    }
    throw new Error("获取文章失败: 未知错误");
  }
}
function parseWeixinArticle(html) {
  let title = "";
  let content = "";
  let author = "";
  const titleMatch1 = html.match(/<h1[^>]*class="[^"]*rich_media_title[^"]*"[^>]*>([\s\S]*?)<\/h1>/i);
  if (titleMatch1) {
    title = cleanText(titleMatch1[1]);
  }
  if (!title) {
    const titleMatch2 = html.match(/<h1[^>]*id="activity-name"[^>]*>([\s\S]*?)<\/h1>/i);
    if (titleMatch2) {
      title = cleanText(titleMatch2[1]);
    }
  }
  if (!title) {
    const ogTitleMatch = html.match(/<meta[^>]*property="og:title"[^>]*content="([^"]*)"[^>]*>/i);
    if (ogTitleMatch) {
      title = cleanText(ogTitleMatch[1]);
    }
  }
  const contentMatch = html.match(/<div[^>]*id="js_content"[^>]*>([\s\S]*?)<\/div>\s*(?:<script|<div[^>]*class="rich_media_tool)/i);
  if (contentMatch) {
    content = processHtmlContent(contentMatch[1].trim());
  } else {
    const contentMatch2 = html.match(/<div[^>]*id="js_content"[^>]*>([\s\S]*?)<\/div>(?=\s*<div[^>]*id="js_pc_qr_code)/i);
    if (contentMatch2) {
      content = processHtmlContent(contentMatch2[1].trim());
    }
  }
  const authorMatch = html.match(/<a[^>]*id="js_name"[^>]*>([\s\S]*?)<\/a>/i);
  if (authorMatch) {
    author = cleanText(authorMatch[1]);
  }
  if (!title && !content) {
    throw new Error("无法解析文章内容，请确认链接是否正确");
  }
  console.log("解析结果 - 标题:", title);
  console.log("解析结果 - 内容长度:", content.length);
  return { title, content, author };
}
const IMAGE_PROXY_URL = "https://wei.ltd.com/api/collect/images?url=";
function processHtmlContent(html) {
  let result = html;
  result = result.replace(/<script[\s\S]*?<\/script>/gi, "");
  result = result.replace(/<style[\s\S]*?<\/style>/gi, "");
  result = result.replace(/<!--[\s\S]*?-->/g, "");
  result = result.replace(/<img([^>]*?)data-src="([^"]+)"([^>]*?)>/gi, (_match, before, dataSrc, after) => {
    let newBefore = before.replace(/src="[^"]*"/gi, "").trim();
    let newAfter = after.replace(/src="[^"]*"/gi, "").trim();
    let imgSrc = dataSrc.replace(/&amp;/g, "&");
    if (imgSrc.startsWith("//")) {
      imgSrc = "https:" + imgSrc;
    }
    const proxiedSrc = IMAGE_PROXY_URL + imgSrc;
    return `<img ${newBefore} src="${proxiedSrc}" ${newAfter}>`;
  });
  result = result.replace(/<img([^>]*?)data-lazysrc="([^"]+)"([^>]*?)>/gi, (_match, before, lazySrc, after) => {
    let newBefore = before.replace(/src="[^"]*"/gi, "").trim();
    let newAfter = after.replace(/src="[^"]*"/gi, "").trim();
    let imgSrc = lazySrc.replace(/&amp;/g, "&");
    if (imgSrc.startsWith("//")) {
      imgSrc = "https:" + imgSrc;
    }
    const proxiedSrc = IMAGE_PROXY_URL + imgSrc;
    return `<img ${newBefore} src="${proxiedSrc}" ${newAfter}>`;
  });
  result = result.replace(/<img([^>]*?)src="(https?:\/\/mmbiz\.qpic\.cn[^"]+)"([^>]*?)>/gi, (_match, before, src, after) => {
    if (src.includes("wei.ltd.com/api/collect/images")) {
      return _match;
    }
    let imgSrc = src.replace(/&amp;/g, "&");
    const proxiedSrc = IMAGE_PROXY_URL + imgSrc;
    return `<img ${before} src="${proxiedSrc}" ${after}>`;
  });
  result = result.replace(/visibility\s*:\s*hidden/gi, "visibility: visible");
  result = result.replace(/\s+data-[a-z-]+="[^"]*"/gi, "");
  result = result.replace(/\s+style=""/gi, "");
  result = result.replace(/\n\s*\n/g, "\n");
  return result.trim();
}
function cleanText(text) {
  return text.replace(/<[^>]+>/g, "").replace(/&nbsp;/g, " ").replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/&amp;/g, "&").replace(/&quot;/g, '"').replace(/&#39;/g, "'").replace(/\s+/g, " ").trim();
}
console.log("微信公众号内容提取器 - Background Service Worker 已启动");
